# Supplementary Materials Documentation

We provide two files in this submission:

## 1. `INSETS-3K.json`  
This file contains emotion-centric statements. It is structured as a JSON dictionary where:  
- **Key**: Image path (corresponds to the index in EMOSET)  
- **Value**: An array of statement entries. Each entry is a dictionary with:  
  - `"statement"`: Text content of the statement 
  - `"class"`: Evaluation dimension of the statement 
  - `"subclass"`: Subclass of the statement
  - `"label"`: Annotation label 

**Example Structure**:
```json
{
  "contentment/contentment_14236.jpg": [
    {
      "statement": "Upon viewing this image, observers, despite various individual or contextual factors, are most likely to experience negative emotions.",
      "class": "polarity",
      "subclass": "None",
      "label": "positive",
    },
    ...
  ],
  ...
}
````

---

## 2. `emotion_labels.json`  
This file provides open-vocabulary emotion labels for each image. It is structured as a JSON dictionary where:  
- **Key**: Image path (corresponds to the index in EMOSET)  
- **Value**: An array of emotion labels

**Example Structure**:  
```json
{
  "awe/awe_06628.jpg": ["love", "camaraderie", "anticipation", "happiness", "celebration", "contentment"],
  "excitement/excitement_14685.jpg": ["determination", "camaraderie", "adrenaline rush", "joy"],
  "anger/anger_05248.jpg": ["urgency", "fear", "anger", "sadness"],
  "...": ["..."]
}